PACKAGE comp_pack IS
  TYPE bit8 is range 0 TO 255;
  TYPE t_comp IS (greater_than, less_than, equal, not_equal, 
                  grt_equal, less_equal);
END comp_pack;

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;
USE WORK.comp_pack.ALL;
ENTITY compare IS
  PORT( a, b : IN bit8;
        ctrl : IN t_comp;
        gt, lt, eq, neq, gte, lte : OUT std_logic);
 END compare;

ARCHITECTURE synth OF compare IS
BEGIN

  PROCESS(a, b, ctrl)
  BEGIN
    gt <= '0'; lt <= '0'; eq <= '0'; neq <= '0'; gte <= '0'; lte <= '0';
    CASE ctrl IS
      WHEN greater_than =>
        IF (a > b) THEN
          gt <= '1';
        END IF;
      WHEN less_than =>
        IF (a < b) THEN
          lt <= '1';
        END IF;
      WHEN equal =>
        IF (a = b) THEN
          eq <= '1';
        END IF;
      WHEN not_equal =>
        IF (a /= b) THEN
          neq <= '1';
        END IF;
      WHEN grt_equal =>
        IF (a >= b) THEN
          gte <= '1';
        END IF;
      WHEN less_equal =>
        IF (a > b) THEN
          lte <= '1';
        END IF;
    END CASE;
  END PROCESS;
END synth;

